<?php
// ------------------------------------
// Part 1: Database connection
// ------------------------------------
$host = "webdev.iyaserver.com";
$userid = "dent_student";
$userpw = "code4Studentuse";
$db = "dent_health";

$mysql = new mysqli($host, $userid, $userpw, $db);

if($mysql->connect_errno) {
    echo "db connection error : " . $mysql->connect_error;
    exit();
}
?>

<html>
<head>
    <title>Health Data Insights</title>
    <style>
    body {
        font-family: "Segoe UI", Arial, sans-serif;
        background-color: #fdfaf7;
        color: #2e1f14;
        margin: 0;
    }

    header {
        text-align: center;
        background: linear-gradient(135deg, #8b5e3b, #5e3b23);
        color: white;
        padding: 25px 10px;
        font-size: 28px;
        letter-spacing: 1px;
        box-shadow: 0 3px 8px rgba(0, 0, 0, 0.15);
    }

    h2 {
        color: #5e3b23;
        text-align: center;
        margin-bottom: 10px;
    }

    .summary {
        background-color: #fffdfb;
        border: 1px solid #e6d7c8;
        border-radius: 15px;
        width: 75%;
        margin: 25px auto;
        padding: 20px;
        text-align: center;
        box-shadow: 0 2px 10px rgba(93, 54, 31, 0.1);
    }

    .summary h2 {
        color: #8b5e3b;
        font-size: 22px;
        margin-bottom: 10px;
    }

    .summary p {
        line-height: 1.6;
        font-size: 15px;
    }

    .tablebox {
        background-color: #ffffff;
        width: 90%;
        margin: 0 auto 25px;
        border: 1px solid #e6d7c8;
        border-radius: 15px;
        padding: 15px;
        box-shadow: 0 2px 10px rgba(93, 54, 31, 0.1);
    }

    table {
        border-collapse: collapse;
        width: 100%;
        border-radius: 8px;
        overflow: hidden;
    }

    th, td {
        padding: 10px 12px;
        text-align: center;
    }

    th {
        background-color: #8b5e3b;
        color: #fffaf3;
        font-weight: 600;
    }

    tr:nth-child(even) {
        background-color: #f8f1eb;
    }

    tr:hover {
        background-color: #f0e0d5;
        transition: 0.2s;
    }

    .tablebox h2 {
        color: #8b5e3b;
        font-size: 20px;
        margin-top: 5px;
        margin-bottom: 15px;
    }

    em {
        display: block;
        text-align: center;
        margin-bottom: 25px;
        color: #3e2a1c;
        font-size: 14px;
    }
</style>

</head>
<body>

<header>
    Health Data Insights
</header>

<?php
// ------------------------------------
// Part 2: Aggregate (statistical) query
// ------------------------------------
// Shared WHERE filter (valid subset that exists in your dataset)
$sql = "SELECT 
            COUNT(*) AS Patients,
            AVG(Age) AS AvgAge,
            SUM(BillingAmount) AS TotalBill,
            AVG(BillingAmount) AS AvgBill
        FROM healthcare_dataset
        WHERE 
            Gender='Male' 
            AND Age BETWEEN 30 AND 40
            AND AdmissionType='Urgent'
            AND BloodType='AB+'";

$results = $mysql->query($sql);

if(!$results) {
    echo 'SQL error: ' . $mysql->error . '<hr>' . $sql;
    exit();
}

$currentrow = $results->fetch_assoc();
?>

<div class="summary">
    <h2>Summary Statistics</h2>
    <p>
        There are <strong><?= $currentrow["Patients"] ?></strong> men between ages 30 and 40<br>
        admitted to <strong>Urgent</strong> care with <strong>AB+</strong> blood type.
    </p>
    <p>
        Their average age is <strong><?= round($currentrow["AvgAge"],1) ?></strong><br>
        Their total billing amount is <strong>$<?= number_format($currentrow["TotalBill"],2) ?></strong><br>
        and the average bill per patient is <strong>$<?= number_format($currentrow["AvgBill"],2) ?></strong>.
    </p>
</div>

<?php
// ------------------------------------
// Part 3: Detailed data query (≤ 40 rows)
// ------------------------------------
$sql = "SELECT 
            Name, Age, Gender, BloodType, MedicalCondition, Medication, AdmissionType, TestResults, BillingAmount
        FROM healthcare_dataset
        WHERE 
            Gender='Male' 
            AND Age BETWEEN 30 AND 40
            AND AdmissionType='Urgent'
            AND BloodType='AB+'
        LIMIT 40";

$results = $mysql->query($sql);

if(!$results) {
    echo 'SQL error: ' . $mysql->error . '<hr>' . $sql;
    exit();
}
?>

<div class="tablebox">
    <h2>Patient Records (Max 40)</h2>
    <table>
        <tr>
            <th>Name</th>
            <th>Age</th>
            <th>Gender</th>
            <th>Blood Type</th>
            <th>Condition</th>
            <th>Medication</th>
            <th>Admission</th>
            <th>Test Result</th>
            <th>Billing ($)</th>
        </tr>

        <?php while($currentrow = $results->fetch_assoc()) { ?>
        <tr>
            <td><?= $currentrow["Name"] ?></td>
            <td><?= $currentrow["Age"] ?></td>
            <td><?= $currentrow["Gender"] ?></td>
            <td><?= $currentrow["BloodType"] ?></td>
            <td><?= $currentrow["MedicalCondition"] ?></td>
            <td><?= $currentrow["Medication"] ?></td>
            <td><?= $currentrow["AdmissionType"] ?></td>
            <td><?= $currentrow["TestResults"] ?></td>
            <td>$<?= number_format($currentrow["BillingAmount"],2) ?></td>
        </tr>
        <?php } ?>
    </table>
</div>

<p><em>Insight:</em> Younger male patients in urgent care with AB+ blood type show varying billing totals, likely due to different treatment intensity levels.</p>

</body>
</html>